
IF EXISTS (SELECT* FROM sys.objects
					 WHERE
						object_id = OBJECT_ID(N'[dbo].[P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_EXECUTE_ALL]') AND
						type IN ( N'P', N'PC' ))
	DROP PROCEDURE [dbo].[P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_EXECUTE_ALL]

GO
		  
--EXECUTE P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_EXECUTE_ALL NULL,NULL,2,0
CREATE PROCEDURE [dbo].[P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_EXECUTE_ALL] @DT_INI   DATETIME=NULL,
																	   @DT_FIM      DATETIME=NULL,
 																	   @TP_OPERACAO INT=0,
																	   @CD_FILIAL_PAR INT=0,
																	   @CD_EMP_PAR INT=1

 with ENCRYPTION AS
	BEGIN TRY
		SET NOCOUNT ON

		PRINT 'Reprocessamento de Leitura Z versus importados '

	--Verificando se ha diferenca entre os flags	
	UPDATE
		PDV_CONSLD_VD_MOVIMENTO
	SET 
		FLAG_CAIXA_BLOQUEADO = BLQ_ALT_FECHA,
		FLAG_CAIXA_FECHADO =1
	FROM
		PDV_VD_FECHA_MOV INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON
		PDV_VD_FECHA_MOV.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP AND
		PDV_VD_FECHA_MOV.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL AND
		PDV_VD_FECHA_MOV.DT_MOV = PDV_CONSLD_VD_MOVIMENTO.DT_MOV 
	WHERE
		FLAG_CAIXA_BLOQUEADO <> BLQ_ALT_FECHA
		AND PDV_VD_FECHA_MOV.CD_EMP =@CD_EMP_PAR
		AND PDV_VD_FECHA_MOV.DT_MOV >= GETDATE()-60
	-----------
	--DELETANDO ETAPA NULA
	DELETE
	FROM
		TELE_ORC_ETAPA_PDV_VD
	WHERE
		CD_ORC_ETAPA IS NULL	
	--FIM	
	--Deletando pendencia de movimento bloqueado	
	DELETE
		EST_PROD_CPL_VD_LOTE_PROC_EST_PROD
	from
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE INNER JOIN GLB_DT_MOVIMENTO ON
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
		INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL ON
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_CTR 
		INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_EST_PROD ON
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR = EST_PROD_CPL_VD_LOTE_PROC_EST_PROD.CD_CTR 
		INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON
		GLB_DT_MOVIMENTO.DT_MOVIMENTO = PDV_CONSLD_VD_MOVIMENTO.DT_MOV AND
		EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP AND
		EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL 
	WHERE
		PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_BLOQUEADO=1


	DELETE
		EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL
	from
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE INNER JOIN GLB_DT_MOVIMENTO ON
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
		INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL ON
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_CTR 
		INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON
		GLB_DT_MOVIMENTO.DT_MOVIMENTO = PDV_CONSLD_VD_MOVIMENTO.DT_MOV AND
		EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP AND
		EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL 
	WHERE
		PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_BLOQUEADO=1

	DELETE
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE
	from
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE INNER JOIN GLB_DT_MOVIMENTO ON
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR_DT_MOVIMENTO = GLB_DT_MOVIMENTO.CD_CTR_DT_MOVIMENTO
		INNER JOIN EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL ON
		EST_PROD_CPL_VD_LOTE_PROC_PENDENTE.CD_CTR = EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_CTR 
		INNER JOIN PDV_CONSLD_VD_MOVIMENTO ON
		GLB_DT_MOVIMENTO.DT_MOVIMENTO = PDV_CONSLD_VD_MOVIMENTO.DT_MOV AND
		EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_EMP = PDV_CONSLD_VD_MOVIMENTO.CD_EMP AND
		EST_PROD_CPL_VD_LOTE_PROC_PRC_FILIAL.CD_FILIAL = PDV_CONSLD_VD_MOVIMENTO.CD_FILIAL 
	WHERE
		PDV_CONSLD_VD_MOVIMENTO.FLAG_CAIXA_BLOQUEADO=1
	-----------------------------------------------------------------
	IF EXISTS(SELECT PDV_VD.ST_VD,PDV_VD_CUPONS.ST_VD FROM PDV_VD 
							INNER JOIN PDV_VD_CUPONS ON PDV_VD.CD_EMP = PDV_VD_CUPONS.CD_EMP
										 AND PDV_VD.CD_FILIAL = PDV_VD_CUPONS.CD_FILIAL
										 AND PDV_VD.NR_ECF = PDV_VD_CUPONS.NR_ECF
										 AND PDV_VD.CD_CX = PDV_VD_CUPONS.CD_CX
										 AND PDV_VD.DT_VD = PDV_VD_CUPONS.DT_VD
										 AND PDV_VD.ST_VD <> PDV_VD_CUPONS.ST_VD
					WHERE PDV_VD.CD_EMP=1 AND PDV_VD.DT_VD >= GETDATE() - 10)
	BEGIN
		UPDATE PDV_VD_CUPONS
		SET ST_VD = PDV_VD.ST_VD
		FROM PDV_VD
			INNER JOIN PDV_VD_CUPONS ON PDV_VD.CD_EMP = PDV_VD_CUPONS.CD_EMP
										AND PDV_VD.CD_FILIAL = PDV_VD_CUPONS.CD_FILIAL
										AND PDV_VD.NR_ECF = PDV_VD_CUPONS.NR_ECF
										AND PDV_VD.CD_CX = PDV_VD_CUPONS.CD_CX
										AND PDV_VD.DT_VD = PDV_VD_CUPONS.DT_VD
										AND PDV_VD.ST_VD <> PDV_VD_CUPONS.ST_VD
		WHERE
			--PDV_VD.CD_EMP=1
			--AND PDV_VD.DT_VD >= GETDATE() - 10;
			PDV_VD_CUPONS.DT_VD >= GETDATE() - 10
	END
	
		create table #dont_del (cd_emp int,
								cd_filial int,
								dt_mov date)

		DECLARE @CD_FILIAL INT
		DECLARE @DT_INI_PROC DATETIME
		DECLARE @DT_FIM_PROC DATETIME
		declare @DtAnalise  date, @DtAnaliseFim date; 

		IF @DT_INI IS NULL
			BEGIN
				SELECT @DT_INI = convert(date, getdate()-1);
				SET @DT_FIM = @DT_INI 
			END

		  INSERT INTO #dont_del 
		  select 
			 b.cd_emp,
			 b.cd_filial,
			 b.dt_mov
		  from 
			 PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR B 
			 join PDV_CONSLD_VD_MOVIMENTO csld  on 
			 b.CD_EMP		  = csld.CD_EMP AND
			 b.CD_FILIAL	  = csld.CD_FILIAL AND
			 b.DT_MOV		  = csld.DT_MOV

			 inner join PDV_VD_FECHA_MOV mov on   
			 csld.cd_emp	  = mov.cd_emp  and  
			 csld.cd_filial   = mov.cd_filial and  
			 csld.dt_mov	  = mov.dt_mov
		  where 
				 (csld.FLAG_CAIXA_BLOQUEADO =1 or mov.BLQ_ALT_FECHA =1)
			 AND MOV.CD_EMP=1;

		  INSERT INTO #dont_del 
		  SELECT  DISTINCT
			  R.CD_EMP
			 ,R.CD_FILIAL
			 ,R.DT_MOV 
		  FROM 
			 PDV_CONSLD_VD_MOVIMENTO C 
			 JOIN PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR R ON 
			 C.CD_EMP	= R.CD_EMP AND 
			 C.DT_MOV	= R.DT_MOV AND 
			 C.CD_FILIAL= R.CD_FILIAL		
			 JOIN RC_ADM_CARTAO_MOV m ON     
			 C.CD_EMP	 = M.CD_EMP	 AND 
			 C.DT_MOV	 = M.DT_LANC	 AND 
			 C.CD_FILIAL  = M.CD_FILIAL					   			     
		  WHERE 
			 FLAG_CARTAO_FECHADO =1
			 AND m.CD_EMP=1 ;

		/****************************************************************************************/
		--Marca caixa fechado no movimento consistente
		/****************************************************************************************/
		UPDATE M
			SET
				FLAG_CAIXA_FECHADO = 1
		FROM PDV_VD_MOVIMENTO_RELATORIOS A
				JOIN PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR B ON A.CD_EMP = B.CD_EMP
															AND A.CD_FILIAL = B.CD_FILIAL
															AND A.DT_MOV = B.DT_MOV
				JOIN PDV_CONSLD_VD_MOVIMENTO M ON A.CD_EMP = M.CD_EMP
														AND A.CD_FILIAL = M.CD_FILIAL
														AND A.DT_MOV = M.DT_MOV
				LEFT JOIN #dont_del D ON A.CD_EMP = D.CD_EMP
										AND A.CD_FILIAL = D.CD_FILIAL
										AND A.DT_MOV = D.DT_MOV
		WHERE
					A.VLR_VENDA_MOVIMENTO = A.VLR_VENDA_RELATORIO
				AND A.VLR_VENDA_MOVIMENTO = A.VLR_VENDA_LEITURA_Z
				AND D.CD_EMP IS NULL;

		 /****************************************************************************************/
		  --Remove movimentos consistentes da pendencia..
		  DELETE FROM B
		  FROM 
			 PDV_VD_MOVIMENTO_RELATORIOS A
			 JOIN PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR B ON 
			 A.CD_EMP	   = B.CD_EMP AND
			 A.CD_FILIAL   = B.CD_FILIAL AND
			 A.DT_MOV	   = B.DT_MOV
			 LEFT JOIN #dont_del D ON 
			 A.CD_EMP	   = D.CD_EMP AND
			 A.CD_FILIAL   = D.CD_FILIAL AND
			 A.DT_MOV	   = D.DT_MOV
		  WHERE
				 A.VLR_VENDA_MOVIMENTO = A.VLR_VENDA_RELATORIO	
			 AND A.VLR_VENDA_MOVIMENTO = A.VLR_VENDA_LEITURA_Z
			 and D.CD_EMP IS NULL;

		/****************************************************************************************/
		--Movimento do inteiro do dia anterior
		IF @TP_OPERACAO = 0
			BEGIN
				DECLARE filiais CURSOR FAST_FORWARD FOR
				SELECT
				    CD_FILIAL
				    ,@DT_INI
				    ,@DT_FIM
				FROM
				    PRC_FILIAL
				WHERE
					CD_EMP = @CD_EMP_PAR	
				    AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR=0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
			END

		--Movimento pendente de processamento
		IF @TP_OPERACAO = 1
			BEGIN 
				--Tabela temporario para ser usada
				--para apagar os dados processados
				
				DECLARE filiais CURSOR FAST_FORWARD FOR
				SELECT
					 CD_FILIAL
					,DT_MOV
					,DT_MOV
				FROM
					PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR
				WHERE
					CD_EMP = @CD_EMP_PAR
					AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR=0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
					 
			END
		Print 'Operacao ' + Convert(varchar,@TP_OPERACAO )
		--Integracao de vendas
		IF @TP_OPERACAO = 2
			BEGIN
				DECLARE filiais CURSOR FAST_FORWARD FOR
					SELECT
						CD_FILIAL
						,CONVERT(DATE, GETDATE())
						,CONVERT(DATE, GETDATE())
					FROM
						PRC_FILIAL
					WHERE
						CD_EMP = @CD_EMP_PAR
						AND CD_FILIAL = CASE WHEN @CD_FILIAL_PAR=0 THEN CD_FILIAL ELSE @CD_FILIAL_PAR END
			END

		OPEN filiais
		FETCH NEXT FROM filiais INTO @CD_FILIAL, @DT_INI_PROC, @DT_FIM_PROC
		WHILE @@FETCH_STATUS = 0
			BEGIN
				set @DtAnalise =@DT_INI_PROC;
				set @DtAnaliseFim =@DT_FIM_PROC;

				PRINT 'Analisando filial '
							+ CONVERT(VARCHAR(10), @CD_FILIAL)
							+ ' Data.: '
							+ CONVERT(CHAR(10), @DT_INI_PROC, 105) + ' a  '
							+ CONVERT(CHAR(10), @DT_FIM_PROC, 105)
							+ ' Time ' + CONVERT(VARCHAR, GETDATE (), 108) 
							
				
				if Exists (select * from pdv_vd_fecha_mov
								where
									BLQ_ALT_FECHA =1
								and CD_EMP    = @CD_EMP_PAR 
								AND CD_FILIAL = @CD_FILIAL 
								AND DT_MOV = @DtAnalise )
				begin
					--Marca as flags.
					EXEC P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_FLAGS 1, @CD_FILIAL, @DT_INI_PROC , @DT_FIM_PROC; 
					Print 'Consta movimento de caixa bloqueado! - P_PDV_CONSLD_VD_MOVIMENTO_GERACAO_EXECUTE_ALL'	
					
				end
				else
				begin 
						
					PRINT 'Consolidacao movimento - Time ' + CONVERT(VARCHAR, GETDATE (), 108)
					PRINT ' Data Analise ini ' + CONVERT(VARCHAR, @DtAnalise, 112) 
					PRINT ' Data Analise fim ' + CONVERT(VARCHAR, @DtAnaliseFim, 112) 

					EXEC P_PDV_CONSLD_VD_MOVIMENTO_GERACAO
							1,
							@CD_FILIAL,
							@DtAnalise,
							@DtAnaliseFim with Recompile;

					PRINT 'Consolidacao relatorios Time ' + CONVERT(VARCHAR, GETDATE (), 108)

					EXEC P_PDV_VD_MOVIMENTO_RELATORIOS_PROC
							1,
							@CD_FILIAL,
							@DtAnalise,
							@DtAnaliseFim with Recompile;	
							
				end	

				IF @TP_OPERACAO = 1
				BEGIN
					PRINT 'Remove pendencia Time ' + CONVERT(VARCHAR, GETDATE (), 108)	
					 


					DELETE P
					FROM   PDV_CONSLD_VD_MOVIMENTO_REPROCESSAR P
					WHERE  CD_EMP    = @CD_EMP_PAR AND
								CD_FILIAL = @CD_FILIAL AND
								DT_MOV  between  @DtAnalise and @DtAnaliseFim
				END
													 
				FETCH NEXT FROM filiais INTO @CD_FILIAL, @DT_INI_PROC, @DT_FIM_PROC					
				 
			END
			  
		CLOSE filiais;
		DEALLOCATE filiais; 
		
END TRY 
BEGIN CATCH

	DECLARE @mensagemErro	varchar(250);
	DECLARE @severidadeErro int;
	DECLARE @estadoErro		int;
	
	SELECT	@mensagemErro = ERROR_MESSAGE(), 
					@severidadeErro = ERROR_SEVERITY(), 
					@estadoErro = ERROR_STATE();

	INSERT INTO ADM_ERRO (numero, severidade, estado, rotina, linha, mensagem, dtErro)
		SELECT
			ERROR_NUMBER() AS numero,
			@severidadeErro AS severidade,
			@estadoErro AS estado,
			ERROR_PROCEDURE() AS rotina,
			ERROR_LINE() AS linha,
			@mensagemErro AS mensagem,
			GETDATE() AS dtErro;

	RAISERROR (@mensagemErro, @severidadeErro, @estadoErro);
	RETURN -2
END CATCH

if @CD_FILIAL_PAR>0
	EXEC P_PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO_ANALISE @CD_EMP_PAR,@CD_FILIAL_PAR,NULL;
else	
	EXEC P_PDV_VD_LEITURA_Z_VERSUS_CONSOLIDADO_ANALISE_EXECUTE_ALL @CD_EMP_PAR
	
EXEC P_RC_CONC_PDV_VD_TEF_PGTO_CONCILIADO_AGRUPAMENTO_PROCESSAR